<?php
/*
Plugin Name: Paramétrage Pixbulle
Description: Paramétrages Pixbulle
Version: 6
*/
add_filter('sanitize_file_name', 'remove_accents' );
update_option('image_default_link_type', 'none');
add_filter( 'xmlrpc_enabled', '__return_false' );


#page login
function joints_login_css() { wp_enqueue_style( 'joints_login_css', get_stylesheet_directory_uri() . '/login.css', false ); } 
function joints_login_url() { return home_url(); } 
function joints_login_title() { return get_option('blogname'); } 

add_action( 'login_enqueue_scripts', 'joints_login_css', 10 ); 
add_filter('login_headerurl', 'joints_login_url'); 
add_filter('login_headertitle', 'joints_login_title'); 

function swan_upgrader_process_complete( $upgrader_object ) {
	global $wp_version;
	$class = get_class($upgrader_object) ;
	
	if ($class!='Plugin_Upgrader' && $class!='Core_Upgrader')
		return ;
		
	$url = 'https://swan.pixbulle.com/api/add_maj/e7M342PFfNnh';
	$headers = array(
		 'Accept: application/json',
		 'Content-Type: application/json',
		 );
	$description = '';	
	if ($class=='Plugin_Upgrader')
	{
		$type = 'plugin';
		$description .= $upgrader_object->skin->plugin_info['Name'] . ' ' . $upgrader_object->skin->plugin_info['Version'] ;
	}
	elseif ($class=='Core_Upgrader')
	{
		$type = 'core';
	}
	
	$data = json_encode( array('site'=>get_site_url(),'type'=>$type,'version'=>$wp_version,'description'=>$description) );
	 
	$handle = curl_init();
	curl_setopt($handle, CURLOPT_URL, $url);
	curl_setopt($handle, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false); 
	curl_setopt($handle, CURLOPT_POST, true);
	curl_setopt($handle, CURLOPT_POSTFIELDS, $data);
	$response = curl_exec($handle);
	//$code = curl_getinfo($handle, CURLINFO_HTTP_CODE);
	curl_close($handle); 
}
add_action( 'upgrader_process_complete', 'swan_upgrader_process_complete', 10, 1 );  


